/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.ella.resource.api.LexileResTypeService;
import com.ella.resource.constants.LexileResTypeEnum;
import com.ella.resource.domain.LexileResTypeRel;
import com.ella.resource.mapper.LexileResTypeMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LexileResTypeServiceImpl
implements LexileResTypeService {
    @Autowired
    private LexileResTypeMapper lexileResTypeMapper;

    public String getLexileLevelCode(String resCode, String lexileLevel) {
        LexileResTypeRel lexileResTypeRel;
        if (lexileLevel == null) {
            lexileLevel = "";
        }
        if ((lexileResTypeRel = this.lexileResTypeMapper.selectByResCode(resCode)) == null || !LexileResTypeEnum.NP.getCode().equals(lexileResTypeRel.getLexileResTypeCode())) {
            lexileLevel = lexileLevel + "L";
        }
        if (lexileLevel.contains("-")) {
            lexileLevel = "BR" + lexileLevel.substring(lexileLevel.indexOf("-") + 1);
        }
        if (lexileResTypeRel != null) {
            if (lexileResTypeRel.getLexileResTypeCode() == null || lexileResTypeRel.getLexileResTypeCode().equals("") || lexileResTypeRel.getLexileResTypeCode().equals("null")) {
                return lexileLevel;
            }
            lexileLevel = lexileResTypeRel.getLexileResTypeCode() + lexileLevel;
        }
        return lexileLevel;
    }

    public void replaceLexileResTypeRel(String resType, String resCode, String lexileResTypeCode) {
        LexileResTypeRel lexileResTypeRel = LexileResTypeRel.builder().lexileResTypeCode(lexileResTypeCode).resType(resType).resCode(resCode).build();
        LexileResTypeRel record = this.lexileResTypeMapper.selectByResCode(resCode);
        if (record == null) {
            this.lexileResTypeMapper.insertSelective(lexileResTypeRel);
        } else {
            this.lexileResTypeMapper.udpateByResCodeAndType(lexileResTypeRel);
        }
    }
}

