/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.service;

import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.EllaCoinConfigService;
import com.ella.resource.domain.CoinConfig;
import com.ella.resource.domain.CoinConfigExample;
import com.ella.resource.dto.ellacoin.CoinConfigDto;
import com.ella.resource.dto.ellacoin.GetEllaCoinListByConditRequest;
import com.ella.resource.dto.sendgoods.StatusEnum;
import com.ella.resource.mapper.CoinConfigMapper;
import com.ella.resource.utils.ResponseParamUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EllaCoinConfigServiceImpl
implements EllaCoinConfigService {
    private static final Logger log = LogManager.getLogger(EllaCoinConfigServiceImpl.class);
    @Autowired
    private CoinConfigMapper coinConfigMapper;

    public ResponseParams<List<CoinConfigDto>> getEllaCoinConfigList(String type) {
        log.info("getEllaCoinConfigList");
        CoinConfigExample exam = new CoinConfigExample();
        exam.createCriteria().andStatusEqualTo(StatusEnum.NORMAL.getCode()).andTypeEqualTo(type);
        exam.setOrderByClause("idx asc");
        List list = this.coinConfigMapper.selectByExample(exam);
        if (list == null || list.isEmpty()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        ArrayList<CoinConfigDto> result = new ArrayList<CoinConfigDto>();
        for (CoinConfig config : list) {
            CoinConfigDto dto = new CoinConfigDto();
            BeanUtils.copyProperties((Object)config, (Object)dto);
            result.add(dto);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, result);
    }

    @EnableValidate
    public ResponseParams<List<CoinConfigDto>> getEllaCoinConfigListByCondit(@RequestBody GetEllaCoinListByConditRequest req) {
        log.info("getEllaCoinConfigListByCondit -- - req :{}", (Object)req);
        if (req.getCoinCodes().isEmpty()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        CoinConfigExample exam = new CoinConfigExample();
        exam.createCriteria().andStatusEqualTo(StatusEnum.NORMAL.getCode()).andCoinCodeIn(req.getCoinCodes());
        exam.setOrderByClause("idx asc");
        List list = this.coinConfigMapper.selectByExample(exam);
        if (list == null || list.isEmpty()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        ArrayList<CoinConfigDto> result = new ArrayList<CoinConfigDto>();
        for (CoinConfig config : list) {
            CoinConfigDto dto = new CoinConfigDto();
            BeanUtils.copyProperties((Object)config, (Object)dto);
            result.add(dto);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, result);
    }

    public ResponseParams<List<CoinConfigDto>> getVipCardConfigByItemCode(String itemCodeStr) {
        if (StringUtils.isBlank((CharSequence)itemCodeStr)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        String[] items = itemCodeStr.trim().split(";");
        List<String> itemList = Arrays.asList(items);
        List vipCardConfig = this.coinConfigMapper.getVipCardConfigByItemCode(itemList);
        if (vipCardConfig == null || vipCardConfig.isEmpty()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, null);
        }
        ArrayList resultList = new ArrayList();
        vipCardConfig.stream().forEach(coinConfig -> {
            CoinConfigDto configDto = new CoinConfigDto();
            BeanUtils.copyProperties((Object)coinConfig, (Object)configDto);
            resultList.add(configDto);
        });
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, resultList);
    }
}

