/*
 * Decompiled with CFR 0.152.
 */
package com.ella.resource.mapper.cache;

import com.ella.frame.aop.util.DataCacheHandler;
import com.ella.frame.cache.DistributedCache;
import com.ella.resource.utils.CacheEnum;
import com.ella.resource.utils.CacheUtilsNew;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCacheHandlerImpl
implements DataCacheHandler {
    @Autowired
    private DistributedCache redisCache;

    public Object handleForOne(String operation, Set<String> serviceCacheSet, String resourceName) {
        String key = "db_resource_" + resourceName;
        if (!"SELECT".equals(operation)) {
            this.redisCache.batchDelLike(key + "*");
            if (serviceCacheSet != null) {
                serviceCacheSet.forEach(s -> {
                    String[] valueStr = s.split(":");
                    if (!valueStr[1].equals(resourceName)) {
                        return;
                    }
                    new CacheUtilsNew(this.redisCache, "service_resource_" + s, null, CacheEnum.INCR).run();
                });
            }
            return null;
        }
        Object result = this.redisCache.getBytesObject(key);
        return result;
    }

    public void cache(String cacheLevel, String uid, String methodName, String resourceName, Object data) {
        String key = "one".equals(cacheLevel) ? "db_resource_" + resourceName : "service_resource_" + methodName + ":" + uid;
        new CacheUtilsNew(this.redisCache, key, data, CacheEnum.SET_BYTES).run();
    }
}

