package com.ella.resource.elladefined;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 关卡通关参数验证
 *
 * @author LiBin
 * @email libin@ellabook.cn
 * @date 2019-04-12 17:17
 **/
@Target({ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = MissionCheckImpl.class)
public @interface MissionCheck {

    String message() default "unknown error";

    String condition() default "";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

}
