package com.ella.resource.dto.word;

import com.ella.resource.dto.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author:wangshuzheng
 * @date:2019/12/9 下午1:59
 * @des:
 */
@ApiModel("单词本-单词列表请求body")
@Data
public class WordListRequest extends BaseRequest {
    @ApiModelProperty(value = "单词来源类别 base-基础词库 know-猜你不认识 collect-我的收藏 follow-我的跟读",required = true)
     private String sourceType;

    @ApiModelProperty(value = "页码",required = true)
    private Integer pageNo;

    @ApiModelProperty(value = "每页数量",required = true)
    private int pageSize;

    @ApiModelProperty(value = "类别id",notes = "基础词库单词列表时 必传")
    private Long categoryId;
}
