package com.ella.resource.dto.word;

import com.ella.resource.dto.ExampleSentence;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author:wangshuzheng
 * @date:2019/12/11 下午5:49
 * @des:
 */
@ApiModel("单词本-单词详情 返回data")
@Data
public class UserWordDetailResponse {
    @ApiModelProperty("单词")
    private String word;
    @ApiModelProperty("图片url")
    private String imgUrl;
    @ApiModelProperty("释义")
    private String explains;
    @ApiModelProperty("0-没有收藏 1-已经收藏")
    private Integer isCollect;
    @ApiModelProperty("0-不认识 1-认识")
    private Integer isKnow;
    @ApiModelProperty("跟读url")
    private String voiceUrl;
    @ApiModelProperty(value = "跟读分数")
    private float followScore;
    @ApiModelProperty("来源")
    private List<WordSourceBook> wordSourceBookList;
    @ApiModelProperty("来源例句")
    private List<ExampleSentence> exampleSentences;
}
