package com.ella.resource.dto.word;

import com.ella.resource.dto.request.BaseRequest;
import io.swagger.annotations.ApiModel;


import io.swagger.annotations.ApiModelProperty;

import lombok.Data;

/**
 * @author:wangshuzheng
 * @date:2019/12/11 下午5:49
 * @des:
 */
@ApiModel("单词本-单词详情 请求body")
@Data
public class UserWordDetailRequest extends BaseRequest {

    @ApiModelProperty(value = "类别id",notes = "单词来源类别为base时 必传")
    private Long categoryId;
    @ApiModelProperty("单词")
    private String word;
    @ApiModelProperty(value = "单词来源类别 base-基础词库 know-猜你不认识 collect-我的收藏 follow-我的跟读 search-搜索",required = true)
    private String sourceType;
    @ApiModelProperty(value = "页码")
    private Integer pageNo = 1;

    @ApiModelProperty(value = "每页数量")
    private int pageSize=Integer.MAX_VALUE;
}
