package com.ella.resource.dto.word;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;

/**
 * @author:wangshuzheng
 * @date:2019/12/18 下午1:48
 * @des:
 */
@Data
@ApiModel("单词本详情跟读保存记录请求参数")
public class UserFollowRecordRequest {
    @ApiModelProperty(notes="跟读的内容",required=true)
    @NotEmpty
    private String content;

    @ApiModelProperty(notes="跟读类型 注：句子-SENTENCE 单词-WORD",required=true)
    @NotEmpty
    private String contentType;

    @ApiModelProperty(notes="跟读发音地址(注：oss地址)",required=true)
    @NotEmpty
    private String voiceUrl;

    @ApiModelProperty(notes="跟读评测分数（第三方分数）",required=true)
    @NotNull
    private Float detailScore;

    @ApiModelProperty(notes="用户UID",required=false)
    @NotEmpty
    private String uid;

    @ApiModelProperty(notes="跟读场景类型(COURSE-课堂模式,SELF_STUDY-自学模式)",required=true)
    @NotEmpty
    private String followType;
}
