package com.ella.resource.dto.word;

import com.ella.resource.dto.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author:wangshuzheng
 * @date:2019/12/12 下午2:19
 * @des:
 */
@ApiModel("单词本-保存用户跟读记录请求body")
@Data
public class SaveUserWordFollowRequest extends BaseRequest {
    @ApiModelProperty(value = "单词" ,required = true)
    private String word;
    @ApiModelProperty(value = "关卡code" )
    private String missionCode;
    @ApiModelProperty(value = "跟读url",required = true)
    private String voiceUrl;
    @ApiModelProperty(value = "跟读分数",required = true)
    private float followScore;
    @ApiModelProperty(value = "单词跟读来源类别 COURSE-课堂模式 SELF_STUDY-自学模式 WORD-单词本详情跟读",required = true)
    private String followType;
    @ApiModelProperty(value = "类别id",notes = "WORD-单词本详情跟读 必传")
    private Long categoryId;
    @ApiModelProperty(value = "例句",notes = "分词模式下跟读传")
    private String sentence;
}
