package com.ella.resource.dto.sendgoods;


/**
 * 数据状态枚举
 * */
public enum StatusEnum {
	/**
	 * 数据状态-正常
	 */
	NORMAL("NORMAL", "正常"),
	/**
	 * 数据状态-删除
	 */
	DELETE("DELETE", "删除")
    ;
	private final String code;

	private final String msg;


	StatusEnum(String code, String msg) {
		this.code = code;
		this.msg = msg;
	}

	
	public String msg() {
		return this.msg;
	}

	 public static StatusEnum getEnumByCode(String code) {
	        for (StatusEnum retCodeEnum : StatusEnum.values()) {
	        	if (retCodeEnum.code.equals(code)) {
	                return retCodeEnum;
	            }
	        }
	        return null;
	    }


	public String getCode() {
		return code;
	}


	public String getMsg() {
		return msg;
	}
}
