package com.ella.resource.dto.sendgoods;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.NotEmpty;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("发送货物入参")
public class SendGoodsToUserRequest implements Serializable {

	private static final long serialVersionUID = 5310154419099389579L;
	
	
	/**
	 * 要发货的物品列表
	 * key - 物品编码
	 * value -对应的资源类型
	 * */
	@ApiModelProperty("要发货的物品列表  key - 物品编码 value -对应的资源类型 ")
	@NotNull
	private Map<String,ResTypeEnum> items;
	
	@NotEmpty
	private String userId;
	
	@NotEmpty
	private String orderNo;
	
	@NotNull
	private BigDecimal orderActual;
	
	@NotEmpty
	private String clientType;
}
