package com.ella.resource.dto.sendgoods;

/**
 * @author Libin
 */
public enum ResTypeEnum {

	/**
	 * 资源类型
	 */
	MAP("MAP", "地图"),
	MESSION("MESSION", "关卡"),
	/**
	 * 绘本每个地方用的code不一样，故有两个
	 */
	BOOK("BOOK", "绘本"),
	COURSE("COURSE","课程"),
	PICTUREBOOK("PICTUREBOOK","绘本"),
	QUESTION("QUESTION","题库"),
	EXAM("EXAM","考试"),
	TEST("TEST","测试"),
	MISSION("MISSION","关卡"),
	ELLA_COIN("ELLA_COIN","咿啦币")
	;
	
	private final String code;

	private final String msg;


	ResTypeEnum(String code, String msg) {
		this.code = code;
		this.msg = msg;
	}

	
	public String msg() {
		return this.msg;
	}

	 public static ResTypeEnum getEnumByCode(String code) {
	        for (ResTypeEnum retCodeEnum : ResTypeEnum.values()) {
	        	if (retCodeEnum.code.equals(code)) {
	                return retCodeEnum;
	            }
	        }
	        return null;
	    }


	public String getCode() {
		return code;
	}


	public String getMsg() {
		return msg;
	}
}
