package com.ella.resource.dto.sendgoods;


/**
 * 获取方式枚举
 * */
public enum FetchTypeEnum {

	/**
	 * 购买
	 */
	BUY("BUY", "购买"),
	/**
	 * 邀请获得
	 */
	INVITE("INVITE", "邀请获得"),
	/**
	 * 体验
	 */
	CSS("CSS", "体验"),
	/**
	 * 赠送
	 */
	GIVE("GIVE", "赠送"),
	/**
	 * 分享
	 */
	SHARE("SHARE", "分享")
    ;
	private final String code;

	private final String msg;


	FetchTypeEnum(String code, String msg) {
		this.code = code;
		this.msg = msg;
	}

	
	public String msg() {
		return this.msg;
	}

	 public static FetchTypeEnum getEnumByCode(String code) {
	        for (FetchTypeEnum retCodeEnum : FetchTypeEnum.values()) {
	        	if (retCodeEnum.code.equals(code)) {
	                return retCodeEnum;
	            }
	        }
	        return null;
	    }


	public String getCode() {
		return code;
	}


	public String getMsg() {
		return msg;
	}
}
