package com.ella.resource.dto.request.question;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@Data
@ApiModel("蓝思评测答题记录")
public class QuestionLexileRecordDto implements Serializable {
	private static final long serialVersionUID = 5769214012632386833L;

	@ApiModelProperty(value = "答题记录ID")
	private Long id;

	@ApiModelProperty(value = "评测记录ID")
	private Long lexileHistoryId;

	@ApiModelProperty(value = "题目ID")
	private Long questionId;

	@ApiModelProperty(value = "等级编号")
	private String levelCode;

	@ApiModelProperty(value = "题目序号")
	private Integer questionOrder;

	@ApiModelProperty(value = "用户选项")
	private String optionKey;

	@ApiModelProperty(value = "正确选项")
	private String optionKeyCorrect;

	@ApiModelProperty(value = "用户UID")
	private String uid;

	@ApiModelProperty(value = "创建时间")
	private Date createTime;
}
