package com.ella.resource.dto.request.question;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@ApiModel("题目选项")
@EqualsAndHashCode()
public class QuestionItemRequest implements Serializable{
	private static final long serialVersionUID = -3354791182940194447L;
	
	@ApiModelProperty(notes = "题目选项ID", required = false)
	private Long id;
	@ApiModelProperty(notes="选项key（注：有序。题目类型为拼图时，选项key升序代表拼图正确答案）", required = true)
	private String itemKey;

	@ApiModelProperty(notes="选项资源（如:图片选项）", required = true)
	private String resItem;

	@ApiModelProperty(notes="文字选项")
	private String textItem;

	@ApiModelProperty(notes="是否多选（适用对象：题目类型未选择题）", required = true)
	private Boolean isMultiChocie;

	@ApiModelProperty(notes="答案解析")
	private String answerAnalysis;

	@ApiModelProperty(notes="是否正确答案（适用对象：题目类型为选择题）", required = true)
	private Boolean isTrueAnswer;
}
