package com.ella.resource.dto.request.question;

import java.io.Serializable;

import com.ella.resource.dto.PageDto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("题目查询条件")
public class QueryResQuestionRequest extends  PageDto implements Serializable{

	private static final long serialVersionUID = -6136923514976084480L;
	
	@ApiModelProperty(notes="题目id", required = false)
	private Long id;
	
	@ApiModelProperty(notes = "题目等级ID" ,required = true)
	private String questionLevelId;
	
	@ApiModelProperty(notes="书名", required = false)
	private String bookName;
	
	@ApiModelProperty(notes="知识点", required = false)
	private String knowledgePoint;
	
	@ApiModelProperty(notes="题目等级名称", required = false)
	private String questionLevelName;
	
	@ApiModelProperty(notes="题目类型", required = false)
	private String questionType;
	
	@ApiModelProperty(notes="知识点类型", required = false)
	private String knowledgeType;
	
	@ApiModelProperty(notes="使用状态", required = false)
	private String useStatus;
	
	@ApiModelProperty(notes="搜索名称（注：支持书名，知识点模糊匹配）",required=false)
	private String searchName;

}
