package com.ella.resource.dto.request.question;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import com.ella.resource.dto.LevelDto;
import com.ella.resource.dto.LevelInfoDto;
import com.ella.resource.dto.LexileLevelHistoryDto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("蓝思评测历史详情")
public class LexileEvaHistoryDetailDto implements Serializable {
	private static final long serialVersionUID = -3928886159413445450L;

	@ApiModelProperty("评测记录")
	private LexileLevelHistoryDto history;

	@ApiModelProperty("等级信息")
	private LevelDto levelInfo;

	@ApiModelProperty("是否晋级")
	private Boolean promotion = Boolean.FALSE;

	@ApiModelProperty(value = "错题对应的关卡信息")
	private List<Map<String, Object>> missionInfo;
	
	@ApiModelProperty(value="继续闯关的MapId")
	private String mapId;
	/**
	 * 用户的能量石数
	 */
	private Integer stoneNum;
	/**
	 * 等级资源是否溢出
	 */
	private Boolean levelOverFlow = Boolean.FALSE;

	@ApiModelProperty("所有等级信息")
	private List<LevelInfoDto> levelAllInfo;

	@ApiModelProperty(notes = "上次评测的完成时间")
	private String lastTestTime;

	@ApiModelProperty(notes = "能够开启评测的时间")
	private String enableTime;

	@ApiModelProperty(notes = "是否能再次开启蓝思评测")
	private Boolean isEnable;
}