package com.ella.resource.dto.request.question;

import com.ella.resource.dto.LevelDto;
import com.ella.resource.dto.LexileEvaluationDto;
import com.ella.resource.dto.LexileLevelHistoryDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

@Data
@ApiModel("蓝思评测答题返回")
public class LexileAnswerResponse implements Serializable {

    private static final long serialVersionUID = -167966407916673677L;

    @ApiModelProperty(value = "是否保存成功", hidden = true)
    private Boolean saved;

    @ApiModelProperty(value = "是否启用新的题目（定级测试，前十题得分小于3时为true）")
    private boolean newQuestions = false;

    @ApiModelProperty("评测详情(定级评测，前十10得分小于3时，返回LV1评测题目)")
    private LexileEvaluationDto evaluation;

    @ApiModelProperty("评测记录(交卷后返回蓝思值及定级等级)")
    private LexileLevelHistoryDto result;

    @ApiModelProperty("等级结果(交卷后返回蓝思值及定级等级)")
    private LevelDto levelInfo;

    @ApiModelProperty("是否晋级(交卷后返回)")
    private Boolean promotion = Boolean.FALSE;

    @ApiModelProperty(value = "错题对应的关卡信息")
    private List<Map<String, Object>> missionInfo;

    @ApiModelProperty(value = "继续闯关的MapId")
    private Long mapId;

    /**
     * 测试之前的用户等级code
     */
    private String originalLevelCode;
    /**
     * 用户拥有的能量石数
     */
    private Integer stoneNum;
}
