package com.ella.resource.dto.request.question;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("蓝思评测答题请求")
public class LexileAnswerRequest implements Serializable {
	private static final long serialVersionUID = -8611389655493136037L;

	@NotNull
	@ApiModelProperty(value = "用户UID", hidden = true)
	private String uid;

	@NotNull
	@ApiModelProperty(value = "评测记录ID", required = true)
	private Long evaluationHistoryId;

	@NotNull
	@ApiModelProperty(value = "题目ID", required = true)
	private Long questionId;

	@NotNull
	@ApiModelProperty(value = "答案Key值(A/B/C/D)")
	private String answerKey;
	
	
	@ApiModelProperty(value="是否交卷(0:不是，1:是)")
	private Integer handOver = 0;
}
