package com.ella.resource.dto.request.question;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@ApiModel("编辑题目入参")
@EqualsAndHashCode()
public class EditResQuestionRequest implements Serializable {

	private static final long serialVersionUID = 1L;
	@ApiModelProperty(notes = "题目ID" , required = true)
	private Long id ;
	@ApiModelProperty(notes = "题目等级ID")
	private String questionLevelId;

	@ApiModelProperty(notes ="题目等级名称")
	private String questionLevelName;

	@ApiModelProperty(notes ="题目类型 CHOICE-选择，CONNECT-连线，DRAG-拖拽，JIGSAW-拼图,RANDOM-随机")
	private String questionType;

	@ApiModelProperty(notes ="题目名称")
	private String questionName;

	@ApiModelProperty(notes ="分值")
	private Integer score;

	@ApiModelProperty(notes ="书名")
	private String bookName;

	@ApiModelProperty(notes ="知识点")
	private String knowledgePoint;

	@ApiModelProperty(notes ="知识点类型")
	private String knowledgeType;

	@ApiModelProperty(notes ="音频(题目类型为选择题时使用该字段)")
	private String voice;

	@ApiModelProperty(notes ="正确答案")
	private String correctAnswer;

	@ApiModelProperty(notes ="题目使用状态 (N-未使用，Y-已使用)")
	private String useStatus = "N";

	@ApiModelProperty(notes ="创建人")
	private String createBy;

	@ApiModelProperty(notes ="创建时间")
	private Date createTime;

	@ApiModelProperty(notes ="修改人")
	private String updateBy;

	@ApiModelProperty(notes ="修改时间")
	private Date updateTime;

	@ApiModelProperty(notes ="数据状态(NORMAL-正常,DELETE-删除)")
	private String status = "NORMAL";

	@ApiModelProperty(notes ="题目选项列表")
	private List<QuestionItemRequest> itemList;
}
