package com.ella.resource.dto.request.picturebooklevel;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.NotEmpty;

import java.io.Serializable;

/**
 * @author LiBin
 */
@Data
@ApiModel("绘本排序入参")
@EqualsAndHashCode(callSuper = false)
public class SortPictureBookRequest implements Serializable {

    private static final long serialVersionUID = -436876871987454416L;
    @ApiModelProperty(notes = "id", required = true)
    @NotEmpty
    private Integer id;

    @ApiModelProperty(notes = "操作类型（向上 up,向下 down）", required = true)
    @NotEmpty
    private String operateType;
}
