package com.ella.resource.dto.request.mission;

import com.ella.resource.dto.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author LiBin
 */
@Data
@ApiModel(" 关卡修改入参")
@EqualsAndHashCode()
public class UpdateMissionRequest extends BaseRequest implements Serializable {
    private static final long serialVersionUID = 2876530350476984862L;
    @ApiModelProperty(notes = " 关卡id", required = true)
    @NotNull
    private Long id;

    @ApiModelProperty(notes = "名称")
    private String missionName;

    @ApiModelProperty(notes = "关卡类型 0：神秘关卡 1:课程  2:阶段性测验 3:考试  4：蓝思评测")
    private Integer missionType;

    @ApiModelProperty(notes = "资源id")
    @NotNull
    private Integer resourceId;

    @ApiModelProperty(notes = "资源名称")
    private String resourceName;

    @ApiModelProperty(notes = "父关卡(nature为神秘关卡不能为空)")
    private String parentCode;

    @ApiModelProperty(notes = "过关答题正确数")
    private Integer passNum;

    @ApiModelProperty(notes = "地图主键")
    private Long mapId;

}
