package com.ella.resource.dto.request.mission;

import com.ella.resource.dto.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author LiBin
 */
@Data
@ApiModel(" 关卡新增入参")
@EqualsAndHashCode()
public class SaveMissionRequest extends BaseRequest implements Serializable {
    private static final long serialVersionUID = 4570994083538490561L;

    @ApiModelProperty(notes = "名称")
    private String missionName;

    @ApiModelProperty(notes = "地图id")
    @NotNull
    private Long mapId;

    @ApiModelProperty(notes = "关卡在地图位置(坐标)")
    @NotEmpty
    private String missionCoords;

    @NotNull
    @ApiModelProperty(notes = "关卡类型 0：神秘关卡 1:课程  2:阶段性测验 3:考试  4：蓝思评测")
    private Integer missionType;

    @ApiModelProperty(notes = "关卡序号")
    private Integer missionIndex;

    @ApiModelProperty(notes = "资源id")
    private Integer resourceId;

    @ApiModelProperty(notes = "资源名称")
    private String resourceName;

    @ApiModelProperty(notes = "父关卡(nature为神秘关卡不能为空)")
    private String parentCode;

    @ApiModelProperty(notes = "过关答题正确数")
    private Integer passNum;
}
