package com.ella.resource.dto.request.mission;

import com.ella.resource.dto.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @ClassName MoveMissionRequest
 * @Description 地图课程关卡移动入参
 * @Author Cui
 * @Date 2019年5月9日10:25:37
 * @Version 1.0
 **/
@Data
@ApiModel("地图关卡移动入参")
@EqualsAndHashCode()
public class MoveMissionRequest extends BaseRequest implements Serializable {
    private static final long serialVersionUID = 2870030350476984862L;

    @ApiModelProperty(notes = "置顶/置底：向上为true，向下为false")
    private Boolean topOrBottom;

    @ApiModelProperty(notes = "上下移动 : 向上为true，向下为false")
    private Boolean upOrDown;

    @ApiModelProperty(notes = "关卡id", required = true)
    @NotNull
    private Long id;
}
