package com.ella.resource.dto.request.mission;

import java.io.Serializable;

import com.ella.resource.dto.PageDto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;


@Data
@ApiModel("关卡及关联等级列表查询入参")
@EqualsAndHashCode(callSuper=false)
public class GetMissionLevelListRequest extends PageDto implements Serializable {
    private static final long serialVersionUID = -8465207607566837088L;

    @ApiModelProperty(notes = "等级code", required = false)
    private String levelCode;
    
    @ApiModelProperty(notes = "关卡类型 0：神秘关卡 1:课程  2:阶段性测验 3:考试  4：蓝思评测", required = false)
    private String missionType;
    
    @ApiModelProperty(notes = "关卡名称", required = false)
    private String missionName;
    
    @ApiModelProperty(notes = "关卡编码", required = false)
    private String missionCode;
    
    @ApiModelProperty(notes="使用场景 （课程：COURSE，绘本馆PICTUREBOOK,考试：EXAM,测试：TEST,关卡：MISSION,商品: GOODS）",required=false)
    private String applyType;
    
    @ApiModelProperty(notes="搜索名称（注：支持等级名称，关卡名称模糊匹配，及关卡类型名称精确匹配）")
    private String searchName;
}
