package com.ella.resource.dto.request.map;

import com.ella.resource.dto.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author LiBin
 */
@Data
@ApiModel("编辑地图入参")
@EqualsAndHashCode()
public class UpdateMapRequest extends BaseRequest implements Serializable {

    private static final long serialVersionUID = 4605691691969084894L;

    @ApiModelProperty(notes = "地图id", required = true)
    @NotNull
    private Long id;

    @ApiModelProperty("地图名称")
    private String mapName;

    @ApiModelProperty("所属等级code")
    private String levelCode;

    @ApiModelProperty("地图所在等级位置序号")
    private Integer levelOrder;

    @ApiModelProperty("所属单元-预留")
    private String unit;
}
