package com.ella.resource.dto.request.map;

import com.ella.resource.dto.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author LiBin
 */
@Data
@ApiModel("新增地图入参")
@EqualsAndHashCode()
public class SaveMapRequest extends BaseRequest implements Serializable {

    private static final long serialVersionUID = -3563603731378328138L;

    @ApiModelProperty(notes = "地图名称", required = true)
    @NotEmpty
    private String mapName;

    @ApiModelProperty(notes = "所属等级code", required = true)
    @NotEmpty
    private String levelCode;

    @ApiModelProperty(notes = "地图所在等级位置序号", required = true)
    private Integer levelOrder;

    @ApiModelProperty("所属单元-预留")
    private String unit;
}
