package com.ella.resource.dto.request.map;

import com.ella.resource.dto.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author LiBin
 */
@Data
@ApiModel("新增地图资源入参")
@EqualsAndHashCode()
public class MapResourceSaveRequest extends BaseRequest implements Serializable {
    private static final long serialVersionUID = 1004514534182974038L;

    @ApiModelProperty(notes = "资源类型(dynamic(动效图),ico(关卡图标),background(背景))", required = true)
    @NotEmpty
    private String resourceType;

    @ApiModelProperty("地图id")
    @NotNull
    private Long mapId;

    @ApiModelProperty("资源url")
    @NotEmpty
    private String url;

    @ApiModelProperty(notes = "序号0,1,2,3,4,5,6(0表示首页动效)--resourceType=dynamic时必填 ")
    private Integer fileOrder;

    @ApiModelProperty(notes = "图标状态-1：未解锁   2：已解锁   3：已下架   4：已完成 5：未完成-------resourceType= ico 时必填")
    private Integer icoStatus;

    @ApiModelProperty(notes = "关卡类型 0：神秘关卡 1:课程  2:阶段性测验 3:考试  4：蓝思评测--------resourceType= ico 时必填")
    private Integer icoType;
}
