package com.ella.resource.dto.request.map;

import com.ella.resource.dto.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author LiBin
 */
@Data
@ApiModel("地图资源删除入参")
@EqualsAndHashCode()
public class MapResourceDeleteRequest extends BaseRequest implements Serializable {

    private static final long serialVersionUID = 6977006883965405293L;

    @ApiModelProperty(notes = "资源类型(dynamic(动效图),ico(关卡图标),background(背景))", required = true)
    @NotEmpty
    private String resourceType;

    @ApiModelProperty("地图id")
    @NotNull
    private Long mapId;

    @ApiModelProperty("资源id")
    private Integer resourceId;
}
