package com.ella.resource.dto.request.map;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @author LiBin
 */
@Data
@ApiModel("查询地图入参")
@EqualsAndHashCode()
public class GetMapListRequest implements Serializable {

    private static final long serialVersionUID = -7791153079465835460L;

    @ApiModelProperty("地图名称")
    private String mapName;

    @ApiModelProperty("所属等级code")
    private String levelCode;

    @ApiModelProperty("所属单元-预留")
    private String unit;
    
    @ApiModelProperty(notes="使用场景 （注：传该参数，只返回在指定场景未被占用的资源,不传返回全部。课程：COURSE，绘本馆PICTUREBOOK,考试：EXAM,测试：TEST,关卡：MISSION,商品: GOODS）",required=false)
    private String applyType;
}
