package com.ella.resource.dto.request.lexile;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@ApiModel("添加蓝思评测入参")
@EqualsAndHashCode
public class SaveLexileEvaluationRequest implements Serializable{

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(notes = "等级ID", required = true)
	private Long levelId;

	@ApiModelProperty(notes = "评测预计消耗时间（分钟）", required = true)
	private Integer expectedTime;

	@ApiModelProperty(notes = "评测需要消耗的能量石数量", required = true)
	private Integer stoneNum;

	@ApiModelProperty(notes = "评测考试的名称", required = true)
	private String evaluationName;

	@ApiModelProperty(notes = "创建时间")
	private Date createTime;

	@ApiModelProperty(notes = "修改时间") 
	private Date updateTime;

	@ApiModelProperty(notes = "数据状态(NORMAL-正常,DELETE-删除)")
	private String status;
}
