package com.ella.resource.dto.request.lexile;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@ApiModel("蓝思评测交卷请求")
public class LexileEvalutionHandOverRequest {

    @ApiModelProperty(value = "用户UID", hidden = true)
    private String uid;

    @NotNull
    @ApiModelProperty(value = "评测记录ID", required = true)
    private Long historyId;

    @NotNull
    @ApiModelProperty(value = "题目答案", required = true)
    private List<UserLexileAnswer> answers;

    @ApiModelProperty(value = "蓝思晋级关卡code",notes = "定级时不传")
    private boolean promotion;

    @ApiModelProperty(value = "关卡id",notes = "定级时不传")
    private Long missionId;
}
