package com.ella.resource.dto.request.lexile;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@ApiModel("编辑蓝思题库属性入参")
@EqualsAndHashCode
public class EditLexileEvaluationRequest implements Serializable {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(notes = "题目ID", required = true)
	@NotNull
	private Long id;

	@ApiModelProperty(notes = "知识点所属等级")
	private String knowledgeLevel;

	@ApiModelProperty(notes = "知识点所属关卡")
	private String knowledgeMission;

	@ApiModelProperty(notes = "题目分数")
	private int questionScore;
	
	@ApiModelProperty(notes = "当题目为图片时，保存图片地址")
	private String questionText;

}
