package com.ella.resource.dto.request.lexile;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@ApiModel("添加蓝思题目入参")
@EqualsAndHashCode
public class EditLexileEvaluationQuestionRequest implements Serializable {
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(notes = "主键ID" , required = true)
	private Long id;
	
	@ApiModelProperty(notes = "题目id", required = true)
	private Long questionId;

	@ApiModelProperty(notes = "蓝思评测id" , required = true)
	private Long evaluationId;
	
	@ApiModelProperty(notes = "关卡id", required = true)
	private Long missionId;

	@ApiModelProperty(notes = "顺序", required = true)
	private Integer idx;

	@ApiModelProperty(notes = "创建人")
	private String createBy;

	@ApiModelProperty(notes = "创建时间")
	private Date createTime;

	@ApiModelProperty(notes = "修改人")
	private String updateBy;

	@ApiModelProperty(notes = "修改时间")
	private Date updateTime;

	@ApiModelProperty(notes = "数据状态(NORMAL-正常,DELETE-删除)")
	private String status;
	
	@ApiModelProperty(notes = "蓝思题目选项信息")
	private List<EditLexileQuestionDetailRequest> detailRequest;
	
}
