package com.ella.resource.dto.request.exam;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@ApiModel("添加考试入参")
@EqualsAndHashCode
public class SaveResExamRequest implements Serializable {
	private static final long serialVersionUID = 1L;
	
	@ApiModelProperty(notes = "名称", required = true)
	private String name;

	@ApiModelProperty(notes = "建议等级Id", required = true)
	private String levelId;

	@ApiModelProperty(notes = "建议等级名称", required = true)
	private String levelName;

	@ApiModelProperty(notes = "评语（注：评语为json串数组）")
	private String remark;

	@ApiModelProperty(notes = "总分", required = true)
	private Integer totalScore;

	@ApiModelProperty(notes = "创建人")
	private String createBy;

	@ApiModelProperty(notes = "创建时间")
	private Date createTime;

	@ApiModelProperty(notes = "修改人")
	private String updateBy;

	@ApiModelProperty(notes = "修改时间")
	private Date updateTime;

	@ApiModelProperty(notes = "数据状态(NORMAL-正常,DELETE-删除)")
	private String status = "NORMAL";
}
