package com.ella.resource.dto.request.exam;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@ApiModel("添加考试题目参数")
@EqualsAndHashCode
public class SaveExamDetailRequest implements  Serializable{
	
	private static final long serialVersionUID = -4210386983873462705L;

	@ApiModelProperty(notes = "题目Id", required = true)
	private Long questionId;

	@ApiModelProperty(notes = "题目顺序", required = true)
	private Short questionOrder;

	@ApiModelProperty(notes = "知识点等级", required = true)
	private String knowledgeLevel;

	@ApiModelProperty(notes = "知识点关卡", required = true)
	private String knowledgeMission;

	@ApiModelProperty(notes = "题目分数")
	private Integer questionScore;

	@ApiModelProperty(notes = "创建人")
	private String createBy;

	@ApiModelProperty(notes = "创建时间")
	private Date createTime;

	@ApiModelProperty(notes = "修改人")
	private String updateBy;

	@ApiModelProperty(notes = "修改时间")
	private Date updateTime;

	@ApiModelProperty(notes = "数据状态(NORMAL-正常,DELETE-删除)")
	private String status;
}
