package com.ella.resource.dto.request.exam;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@ApiModel("考试详情添加属性参数")
@EqualsAndHashCode
public class AddExamDtailPropertyRequest implements Serializable{

	private static final long serialVersionUID = -4137731851072407992L;

	@ApiModelProperty(notes = "考试ID", required = true)
	private Long examId;
	
	@ApiModelProperty(notes = "考试详情ID", required = true)
	private Long detailId;
	
	@ApiModelProperty(notes = "分数", required = true)
	private String questionScore;
	
	@ApiModelProperty(notes = "知识点等级", required = true)
	private String knowledgeLevel;
	
	@ApiModelProperty(notes = "知识点所属关卡", required = true)
	private String knowledgeMission;
}
