package com.ella.resource.dto.request.app;

import com.ella.resource.dto.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author LiBin
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("测验结果的入参")
public class TestAnswerRequest extends BaseRequest {

    private static final long serialVersionUID = 6944161995679971409L;
    @ApiModelProperty(notes = "关卡id", required = true)
    @NotNull
    private Long id;

    @ApiModelProperty(notes = "测试类型(课后小测验-course,阶段性测试-test,考试-exam)", required = true)
    @NotEmpty
    private String testType;

    @ApiModelProperty("答题结果")
    @NotNull
    private List<TestAnswerInfoRequest> answerInfoList;
}
