package com.ella.resource.dto.request.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author LiBin
 */
@Data
@ApiModel("测验结果的入参")
public class TestAnswerInfoRequest implements Serializable {

    private static final long serialVersionUID = -4586120279451420527L;

    @ApiModelProperty("题目id")
    @NotNull
    private Integer questionId;

    @ApiModelProperty("题目类型 CHOICE-选择，CONNECT-连线，DRAG-拖拽，JIGSAW-拼图,RANDOM-随机")
    @NotEmpty
    private String questionType;

    @ApiModelProperty("回答正确与否")
    @NotNull
    private Boolean isTrue;

    @ApiModelProperty("用户选项")
    @NotNull
    private List<TestAnswerItemRequest> testAnswerItems;
}
