package com.ella.resource.dto.request.app;

import com.ella.resource.dto.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;

/**
 * @author LiBin
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("收藏单词")
public class PutUserWordWallRequest extends BaseRequest {

    private static final long serialVersionUID = 2648446001630410083L;
    @ApiModelProperty(notes = "关卡Code", required = true)
    @NotEmpty
    private String missionCode;

    @ApiModelProperty(notes = "图书Code", required = true)
    @NotEmpty
    private String bookCode;

    @ApiModelProperty(notes = "页码", required = true)
    @NotNull
    private Byte pageNum;

    @ApiModelProperty(notes = "单词", required = true)
    @NotEmpty
    private String word;

    @ApiModelProperty(notes = "句子", required = true)
    @NotEmpty
    private String sentence;

    @ApiModelProperty(notes = "句子发音地址", required = true)
    @NotEmpty
    private String ellaSpeechUrl;
}
