package com.ella.resource.dto.request.app;

import com.ella.resource.dto.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

/**
 * @author LiBin
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("记录课程关卡的答题详情")
public class CourseAnswerPutRequest extends BaseRequest {

    private static final long serialVersionUID = 5695339769543634591L;
    @ApiModelProperty(notes = "关卡id", required = true)
    @NotNull
    private Long id;

    @ApiModelProperty(notes = "阅读器返回的json串", required = true)
    @NotNull
    private String jsonContent;

    @ApiModelProperty(notes = "当前页的题目总数", required = true)
    @NotNull
    private Integer totalNum;
}
