package com.ella.resource.dto.request.activity;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("插入活动入参")
public class SaveActivitySendGoodsRequest implements Serializable {
	
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(notes = "活动名称" , required = true)
	private String activityName;

	@ApiModelProperty(notes = "活动描述")
	private String activityInfo;

	@ApiModelProperty(notes = "活动参数人数上限")
	private Integer activityAmount;

	@ApiModelProperty(notes = "使用对象(PERSON-个人,GROUP-群组)" ,required = true)
	private String activityObject;

	@ApiModelProperty(notes = "适用角色(ALL-所有,LV1-等级1,LV2-等级2...LV8-等级8注：适用对象-GROUP时使用该字段,)")
	private String activityRole;
	
	@ApiModelProperty(notes = "是否限制数量 YES,NO")
	private String whetherLimit;

	@ApiModelProperty(notes = "商品编码列表(注：多个商品以逗号分隔)")
	private String goodsCodes;
	
	@ApiModelProperty(notes = "商品名称列表(注：多个商品以逗号分隔)")
	private String goodsNames;

	@ApiModelProperty(notes = "赠送商品数量")
	private Integer sendGoodsNum;

	@ApiModelProperty(notes = "用户账户列表(适用对象-PERSON 注：多个用户以逗号区分)")
	private String userNameList;

	@ApiModelProperty(notes = "活动开始时间" , required = true)
	private Date startTime;

	@ApiModelProperty(notes = "活动结束时间" , required = true)
	private Date endTime;

	@ApiModelProperty(notes = "送书活动类型：H5:H5送书活动，TEM_H5:定制模板H5送书活动，DIRECTIONAL:定向送书，CHANNEL:渠道送书，REGISTER注册送书")
	private String activityType;

	@ApiModelProperty(notes = "渠道编码")
	private String channelCode;

	@ApiModelProperty(notes = "创建人")
	private String createBy;

	@ApiModelProperty(notes = "修改人")
	private String updateBy;

}
