package com.ella.resource.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author LiBin
 */
@Data
@ApiModel("修改等级入参")
@EqualsAndHashCode(callSuper = false)
public class UpdateLevelRequest extends BaseRequest implements Serializable{

    private static final long serialVersionUID = 2206341437541587712L;

    @ApiModelProperty(notes = "等级id", required = true)
    @NotNull
    private Integer id;

    @ApiModelProperty("等级别名(启蒙者)")
    private String levelName;

    @ApiModelProperty("词汇数")
    private Integer vocabularyNum;

    @ApiModelProperty("句型数")
    private Integer grammarNum;

    @ApiModelProperty("拼读数")
    private Integer readingNum;

    @ApiModelProperty("词汇描述")
    private String vocabularyDesc;

    @ApiModelProperty("语法描述")
    private String grammarDesc;

    @ApiModelProperty("阅读描述")
    private String readingDesc;

    @ApiModelProperty("写作")
    private Integer writingNum;

    @ApiModelProperty("写作描述")
    private String writingDesc;

    @ApiModelProperty("阅读能力指数(起始区间)")
    private Integer readStartIndex;

    @ApiModelProperty("阅读能力指数(结束区间)")
    private Integer readEndIndex;

    @ApiModelProperty("等级目标")
    private String target;

    @ApiModelProperty("目标图片关联附件表")
    private String attachCode;

    @ApiModelProperty("等级内容介绍")
    private String introduction;

    @ApiModelProperty("等级能力介绍")
    private String levelAbilityDesc;
}
