package com.ella.resource.dto.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @author ZLN
 * @create 2018-09-03 18:20
 **/
@Data
public class ReadRecordReq implements Serializable {
    private static final long serialVersionUID = -4050289297487684337L;

    @ApiModelProperty(value = "uid",hidden = true)
    private String uid;

    @ApiModelProperty("绘本code")
    @NotBlank
    private String bookCode;

    @ApiModelProperty("阅读页")
    @NotNull
    private Integer pageNum;

    @ApiModelProperty(value = "ip",hidden = true)
    private String readIp;

    @ApiModelProperty("阅读开始时间")
    @NotNull
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date readStart;

    @NotNull
    @ApiModelProperty("阅读结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    @NotNull
    @ApiModelProperty("总页数")
    private Integer totalPage;

    @ApiModelProperty("阅读模式")
    @NotBlank
    private String readModel;

}
