package com.ella.resource.dto.request;

import com.ella.resource.dto.PageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author ZLN
 * @create 2018-07-31 11:53
 **/
@Data
@ApiModel("绘本列表入参")
@EqualsAndHashCode(callSuper=false)
public class PicBookListReq extends PageDto {

	private static final long serialVersionUID = 6298469059670246717L;

	@ApiModelProperty("搜索名字")
    private String name;
    
    @ApiModelProperty("系列名字")
    private String seriesName;
    
    @ApiModelProperty(notes="使用场景 （课程：COURSE，绘本馆PICTUREBOOK,考试：EXAM,测试：TEST,关卡：MISSION,商品: GOODS）",required=false)
    private String applyType;
    
    @ApiModelProperty("等级名称")
    private String levelCode;

    @ApiModelProperty("APP/OTS")
    private String clientType;

    
}
