package com.ella.resource.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;

import java.io.Serializable;

/**
 * @author ZLN
 * @create 2018-08-01 11:30
 **/
@Data
@ApiModel("课程添加视频")
@EqualsAndHashCode()
@ToString
public class CourseVedioReq implements Serializable {
    private static final long serialVersionUID = -4050289297487684337L;

    @NotBlank
    @ApiModelProperty(value = "课程code  eg:KC201807311424532", required = true)
    private String courseCode;

    @ApiModelProperty(value = "视频url",required = true)
    private String videoUrl;
}
