package com.ella.resource.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author ZLN
 * @create 2018-07-30 10:36
 **/
@Data
@ApiModel("课程题目列表入参")
@EqualsAndHashCode()
public class CourseQuestionListReq implements Serializable {
    private static final long serialVersionUID = -4050289297487684337L;
    @ApiModelProperty("课程code")
    @NotBlank
    private String courseCode;

    @ApiModelProperty("课程id")
    @NotNull
    private Long courseId;

    @ApiModelProperty("课程题目列表删除使用,题目code")
    private Long questionId;
}
