package com.ella.resource.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @author ZLN
 * @create 2018-07-31 10:17
 **/

@ApiModel("新增绘本入参")
@Data
public class AddPicBookReq implements Serializable {
    private static final long serialVersionUID = -4050289297487684337L;

    @NotEmpty
    @ApiModelProperty("动画书code")
    private String bookCode;

    @ApiModelProperty("动画书名称")
    private String bookName;

    @ApiModelProperty("动画书系列名")
    private String seriesName;

    @NotEmpty
    @ApiModelProperty("json数组 {forAge:[xx,xx]}")
    private List forAge;

    @NotEmpty
    @ApiModelProperty("蓝思评级")
    private String lexileLevel;

    // @NotEmpty
    @ApiModelProperty("标签  逗号隔开")
    private String tags;


    @ApiModelProperty("可获得能量石数")
    private Integer stoneNum;

    @ApiModelProperty("过关提示语")
    private String winTips;

    @ApiModelProperty("绘本简介")
    private String description;

    @ApiModelProperty("状态  NORMAL:新增  EXCEPTION:删除")
    private String status;

    @ApiModelProperty("id, 删除,修改必传")
    private Integer id;

    @ApiModelProperty("蓝思指数类型")
    private String lexileResTypeCode;

}
