package com.ella.resource.dto.missiondto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author LiBin
 */
@ApiModel("下一个关卡信息")
@Data
public class NextMissionInfoDto implements Serializable {

    private static final long serialVersionUID = -2796965987903016009L;
    @ApiModelProperty(notes = "关卡id")
    private String missionId;

    @ApiModelProperty(notes = "关卡code")
    private String missionCode;

    @ApiModelProperty(notes = "关卡名称")
    private String missionName;

    @ApiModelProperty(notes = "关卡名称")
    private String bookName;

    @ApiModelProperty(notes = "关卡类型(0：神秘关卡 1:课程  2:阶段性测验 3:考试  4：蓝思评测)")
    private Integer missionType;

    @ApiModelProperty(notes = "地图id")
    private String mapId;

    @ApiModelProperty(notes = "地图code")
    private String mapCode;

    @ApiModelProperty(notes = "是否跨越地图")
    private Boolean isCrossMap;

    private String missionCoords;

    private String missionStatus;
    /**
     * 冗余字段 是否是资源关卡
     */
    private boolean snapLastUserMission;
    /**
     * 冗余字段 关卡所属等级code
     */
    private String levelCode;
}
