package com.ella.resource.dto.missiondto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author LiBin
 */
@ApiModel("关卡设置信息")
@Data
public class MissionSetDto implements Serializable {
    private static final long serialVersionUID = 3059447929843669367L;

    @ApiModelProperty(notes = "地图id")
    @NotNull
    private Long mapId;

    @ApiModelProperty(notes = "地图背景")
    private String backgroundUrl;

    @ApiModelProperty(notes = "动效组")
    private List<DynamicDto> dynamicDtoList;

    @ApiModelProperty(notes = "关卡列表集合")
    private List<MissionListDto> missionListDtoList;

    @ApiModelProperty(notes = "图标组---(关卡类型 0：神秘关卡 1:课程  2:阶段性测验 3:考试  4：蓝思评测;" +
            "状态icoStatus-1：未解锁   2：已解锁   3：已下架   4：已完成 5：未完成)")
    private Map<Integer,List<IcoGroupDto>> icoGroupMap;

}
